<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * French language strings for the Via module
 * 
 * @package    mod
 * @subpackage via
 * @copyright  SVIeSolutions <alexandra.dinan@sviesolutions.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * 
 */

$string['manageparticipants'] = 'G&eacute;rer les utilisateurs';
$string['pluginadministration'] = 'Administration de Via';
$string['pluginname'] = 'Via';
$string['pluginversion'] = 'Version : ';
$string['modulename_help'] = 'Le module Via vous permet de cr&eacute;er des rencontres en classe virtuelle synchrone afin d\'&eacute;changer en  direct &agrave; l\'aide de la voix et la vid&eacute;o pour :
-Des classes &agrave; distance en temps r&eacute;el
-Des r&eacute;unions
-Des rencontres pour les travaux d\'&eacute;quipes
-Du tutorat
-Des s&eacute;minaires
-Etc.

L\'outils permet de g&eacute;rer des sous-groupes de travails, d\'annoter, de partager son &eacute;cran, d\'importer/pr&eacute;senter des documents et d\'&eacute;changer par la voix/vid&eacute;o.

L\'option &laquo; Inscription des participants &raquo; vous permet d\'inscrire manuellement les participants ou encore de les synchroniser automatiquement avec les droits de votre espace Moodle par la s&eacute;lection de l\'option &laquo; Inscription automatique &raquo;.

La section &laquo; Param&egrave;tres de sessions &raquo; vous permet de param&eacute;trer l\'enregistrement des rencontres et la disponibilit&eacute; de ces derniers pour vos apprenants.

NB. L\'&eacute;dition et la modification des enregistrements doivent se faire dans l\'environnement Via.';
$string['audiomodelabel'] = 'Mode audio pour la conf&eacute;rence';
$string['portalaccess'] = 'Acc&egrave;s au portail Via.';
$string['portalaccessdesc'] = 'Permet aux utilisateur d\'acc&eacute;der au portail Via  &agrave; partir de leur &eacute;&eacute;tat de session dans Moodle. En effet, lorsque l\'utilisateur acc &egrave;s  &agrave; une activit&eacute; Via  &agrave; partir de Moodle, son &eacute;tat de session est actif dans le
 portail Via et il est en mesure, simplement en ouvrant un nouvel onglet de son navigateur et en acc&eacute;dant au portail, de s\'y connecter sans avoir  &agrave; entrer de code utilisateur/mot de passe. Autrement, si l\'option n\'est pas activ&eacute;e, l\'utilisateur ne
 peut pas se connecter au portail Via  &agrave; partir de son &eacute;tat de session Moodle.';
$string['recentrecordings'] = 'Enregistrement r&eacute;cent';
$string['configassist'] = 'Assistant de configuration';
$string['technicalassist'] = 'Assistance technique';
$string['noanimators'] = 'Aucun animateur n\'est inscrit &agrave; cette activit&eacute;.';
$string['noparticipants'] = 'Aucun participant n\'est inscrit &agrave; cette activit&eacute;.';
$string['subscribeparticipants'] = 'Inscription des usagers';
$string['gotoactivity'] = 'Cliquez ici pour acc&eacute;der &agrave; l\'activit&eacute;';
$string['notstarted'] = 'Cette activit&eacute; n\'a pas encore d&eacute;but&eacute;.';
$string['activitydone'] = 'Cette activit&eacute; est termin&eacute;e.';
$string['reviewactivity'] = 'Cliquez ici pour revoir l\'activit&eacute;.';
$string['prepareactivity'] = 'Pr&eacute;parer votre activit&eacute;.';
$string['notenrolled'] = 'Vous n\'&ecirc;tes pas inscrits &agrave; cette activit&eacute;. Contactez le professeur du cours si vous croyez que vous devez y avoir acc&egrave;s.';
$string['overview'] = 'D&eacute;bute le {$a->start} et se termine le {$a->end}';
$string['participants'] = 'Participants';
$string['participant'] = 'Participant';
$string['animators'] = 'Animateurs';
$string['animator'] = 'Animateur';
$string['presentator'] = 'Pr&eacute;sentateur';
$string['nousers'] = 'Attention - Il n\'y a aucun utilisateur associ&eacute; &agrave; cette activit&eacute;!';

$string['existingparticipants'] = 'Participants actuels';
$string['enroledparticipants'] = 'Participants actuels &agrave; l\'activit&eacute; &laquo; {$a->name} &raquo;';
$string['enroledanimators'] = 'Animateurs actuels &agrave; l\'activit&eacute; &laquo; {$a->name} &raquo;';
$string['existinganimators'] = 'Animateurs actuels';
$string['existingpresentator'] = 'Pr&eacute;sentateur actuel';
$string['potentialparticipants'] = 'Participants potentiels';
$string['potentialanimators'] = 'Animateurs potentiels';
$string['potentialpresentator'] = 'Pr&eacute;sentateurs potentiels';
$string['permanent'] = 'Activit&eacute; permanente';
$string['permanent_help'] = 'Cocher l\'option &laquo; Permanente &raquo; afin de rendre votre activit&eacute; toujours accessible, sans date pr&eacute;cise. Vous serez alors dans l\'obligation d\'utiliser la salle d\'attente afin d\'en limiter l\'acc&egrave;s aux utilisateurs inscrits ayant le statut &laquo; participant &raquo;. ';
$string['startdate'] = 'D&eacute;bute le ';
$string['enddate'] = 'Termine le ';
$string['presence'] = 'Temps minimum requis de pr&eacute;sence';
$string['presence_help'] = 'Valeur correspondante &agrave; la dur&eacute;e en minutes &agrave; partir de laquelle l\'utilisateur obtient le statut de pr&eacute;sence pour l\'activit&eacute;.';
$string['duration'] = 'Dur&eacute;e (minutes)';
$string['timeduration'] = 'Dur&eacute;e :';
$string['headerduration'] = 'Dur&eacute;e';
$string['sessionparameters'] = 'Param&egrave;tres de la session';
$string['roomtype'] = 'Type d\'activit&eacute;';
$string['roomtype_help'] = 'Le type &laquo; Standard &raquo; est une activit&eacute; dans laquelle tous les participants sont list&eacute;s et peuvent interagir normalement, selon le r&ocirc;le attribu&eacute;. Si vous choisissez plut&ocirc;t une activit&eacute; de type &laquo; Webinaire &raquo;, seuls le pr&eacute;sentateur et les animateurs verront les noms des participants. De plus, ces derniers ne pourront interagir autrement que par le clavardage. Ce dernier type est id&eacute;al pour les activit&eacute;s comprenant de larges audiences (plus de 100 participants) ou pour des activit&eacute;s confidentielles.
Lorsque l\'option &laquo; Permanente &raquo; est s&eacute;lectionn&eacute;e, l\'activit&eacute; n\'aura alors plus de date et d\'heure fixe. Tous les participants associ&eacute;s   &agrave; cette activit&eacute; pourront alors y acc&eacute;der   &agrave; n\'importe quel moment. Veuillez prendre note que seul le mode d\'enregistrement multiple est disponible pour ce type d\'activit&eacute;
';
$string['standard'] = 'Standard';
$string['seminar'] = 'S&eacute;minaire';
$string['mode'] = 'Mode audio';
$string['modewebphone'] = 'Voix par conf&eacute;rence t&eacute;l&eacute;phonique';
$string['modevoiceweb'] = 'Voix par Internet';
$string['modephone'] = 'Conf&eacute;rence t&eacute;l&eacute;phonique seulement';
$string['multimediaquality'] = 'Qualit&eacute; multim&eacute;dia';
$string['multimediaquality_help'] = 'S&eacute;lectionnez le profil multim&eacute;dia &agrave; utiliser dans l\'activit&eacute; pour les &eacute;changes multim&eacute;dias (cam&eacute;ra Web, microphone et documents multim&eacute;dias). Cette option peut avoir un impact important sur la fluidit&eacute; des &eacute;changes et sur la bande passante n&eacute;cessaire pour chaque participant. De fa&ccedil;on g&eacute;n&eacute;rale, pour une meilleure exp&eacute;rience ou si vous &ecirc;tes incertain, il est pr&eacute;f&eacute;rable d\'utiliser une qualit&eacute; moindre pour assurer la fluidit&eacute; des &eacute;changes. Il est possible de faire configurer d\'autres profils multim&eacute;dia en fonction de vos besoins sp&eacute;cifiques (par exemple de grandes vignettes vid&eacute;o d\'excellente qualit&eacute; pour une utilisation en mode local). Contactez un de nos experts Via pour en savoir davantage   &agrave; ce sujet.';
$string['highquality'] = 'Qualit&eacute; haute';
$string['mediumquality'] = 'Qualit&eacute; moyenne';
$string['lowquality'] = 'Qualit&eacute; basse';
$string['recordingmode'] = 'Mode d\'enregistrement';
$string['recordingmode_help'] = 'Si vous d&eacute;sirez activer l\'enregistrement de vos activit&eacute;s, deux modes sont offerts : &laquo; Unifi&eacute; &raquo; et &laquo; Multiple &raquo;. La fonction d\'enregistrement unifi&eacute; produira un enregistrement unique peu importe le nombre d\'enregistrements effectu&eacute;s durant la rencontre tandis que les enregistrements multiples sont s&eacute;par&eacute;s et segment&eacute;s dans la liste.';
$string['recordings'] = 'Enregistrement(s) disponible(s) :';
$string['recording'] = 'Enregistrement';
$string['preparation'] = 'Pr&eacute;parer votre activit&eacute; : ';
$string['accessactivity'] = 'Acc&eacute;der &agrave; votre activit&eacute; : ';
$string['edit'] = 'Modifier';
$string['delete'] = 'Supprimer';
$string['save'] = 'Enregistrer';
$string['cancel'] = 'Annuler';
$string['confirmdelete'] = '&Ecirc;tes-vous certain de vouloir supprimer cet enregistrement d&eacute;finitivement ?';
$string['view'] = 'Visionner';
$string['viausers'] = 'Utilisateurs ';
$string['role'] = 'R&ocirc;le';
$string['config'] = 'Configuration';
$string['finish'] = 'Compl&eacute;t&eacute;e';
$string['incomplete'] = 'Incompl&egrave;te';
$string['neverbegin'] = '&Agrave; faire';
$string['recordwarning'] = 'Les activit&eacute;s peuvent &ecirc;tre enregistr&eacute;es. En cochant cette case, vous acceptez d\'&ecirc;tre enregistr&eacute;.';
$string['recordaccept'] = ' J\'accepte';
$string['mustaccept'] = 'Cochez la case pour acc&eacute;der &agrave; l\'activit&eacute;.';
$string['editrecord'] = 'Modification d\'un enregistrement';
$string['editrecord'] = 'Modification d\'un enregistrement';
$string['recordingtitle'] = 'Titre de l\'enregistrement ';
$string['recordingisdownloadable'] = 'L\'enregistrement est t&eacute;l&eacute;chargeable';
$string['recordingisdownloadableinfo'] = 'Important : vous devez d\'abord exporter la vid&eacute;o afin qu\'elle soit disponible pour t&eacute;l&eacute;chargement.';
$string['fullvideo'] = 'Grand format (MP4)';
$string['mobilevideo'] = 'Mobile (MP4)';
$string['audiorecord'] = 'Audio (MP3)';
$string['export'] = 'Visionner/Exporter';
$string['fullvideoinfo'] = 'Tel que disponible en revoir. R&eacute;solution : 1024x768';
$string['mobilevideoinfo'] = 'Optimis&eacute; pour un affichage r&eacute;duit. R&eacute;solution : 480x320';
$string['notactivated'] = 'D&eacute;sactiv&eacute;';
$string['unified'] = 'Unifi&eacute;';
$string['multiple'] = 'Multiple';
$string['nounifiedrecordpermanent'] = 'Le mode &laquo; Unifi&eacute; &raquo; n\'est pas possible pour une activit&eacute; permanente. Veuillez s&eacute;lectionner un choix diff&eacute;rent.';
$string['needconfirmation'] = 'Confirmation de pr&eacute;sence';
$string['needconfirmation_help'] = 'Confirmation de pr&eacute;sence';
$string['confirmationstatus'] = 'Confirmation de la pr&eacute;sence';
$string['confirmation'] = 'Confirmation des participants';
$string['confirmed'] = 'Pr&eacute;sence confirm&eacute;e';
$string['waitingconfirm'] = 'En attente de la confirmation';
$string['refused'] = 'Ne sera pas pr&eacute;sent';
$string['confirmneeded'] = 'Vous devez confirmer votre pr&eacute;sence';
$string['attending'] = 'Je participerai';
$string['notattending'] = 'Je ne participerai pas';
$string['hasconfirmed'] = 'Vous avez confirm&eacute; votre pr&eacute;sence &agrave; l\'activit&eacute;';
$string['hasconfirmednot'] = 'Vous avez confirm&eacute; que vous ne serez pas pr&eacute;sent &agrave; l\'activit&eacute;.';
$string['sendinvite'] = 'Envoyer un courriel d\'invitation';
$string['personalinvitemsg'] = 'Message personnalis&eacute; : ';
$string['submitinvite'] = 'Envoyer les invitations';
$string['invitessend'] = 'Les courriels d\'invitation seront envoy&eacute;s d\'ici 15 minutes.';
$string['reviewacitvity'] = 'Rendre public tous les enregistrements par d&eacute;faut';
$string['reviewacitvity_help'] = 'Dans le cas o&ugrave; vous d&eacute;sirez rendre tous les enregistrements disponibles au visionnement, s&eacute;lectionnez l\'option &laquo; Rendre public tous les enregistrements par d&eacute;faut &raquo;. Dans le cas contraire, aucun participant ne pourra visionner les enregistrements   &agrave; moins de les cocher individuellement dans la liste. Veuillez noter que cette option est modifiable en tout temps, m&ecirc;me lorsque l\'activit&eacute; est termin&eacute;e.';
$string['sendrecall'] = 'Envoyer un courriel de rappel';
$string['sendrecall_help'] = 'Permet de fixer un rappel automatique selon la p&eacute;riode demand&eacute;e. Vous pouvez choisir d\'envoyer un rappel automatiquement   &agrave; tous les participants 1 ou 2 heures avant, 1 ou 2 jours avant et m&ecirc;me 1 semaine avant la tenue de l\'activit&eacute;. Ils recevront alors le rappel directement par courriel.';
$string['norecall'] = 'Aucun rappel';
$string['recallonehour'] = 'Une heure avant';
$string['recalltwohours'] = 'Deux heures avant';
$string['recalloneday'] = 'Un jour avant';
$string['recalltwodays'] = 'Deux jours avant';
$string['recalloneweek'] = 'Une semaine avant';
$string['activitytitle'] = 'Titre de l\'activit&eacute;';
$string['description'] = 'Description ';
$string['enrolmentheader'] = 'Inscription des participants';
$string['enrolmenttype'] = 'Gestion de l\'inscription des participants';
$string['enrolmenttype_help'] = 'Inscription automatique : tous les utilisateurs inscrits au cours seront ajout&eacute;s &agrave; l\'activit&eacute; Via. Si un &eacute;tudiant est ajout&eacute; au cours apr&egrave;s la cr&eacute;ation de l\'activit&eacute; Via, il sera ajout&eacute; lors de la prochaine synchronisation du Cron. Si par compte il acc&egrave;de   &agrave; l\'activit&eacute; avant que le cron l\'ait ajout&eacute;, il sera ajout&eacute;   &agrave; l\'affichage de la page des d&eacute;tails de l\'activit&eacute;. Les utilisateurs inscrits avec des droits d\'&eacute;dition dans le cours moodle seront automatiquement synchronis&eacute;s comme animateurs, mais cette liste demeure &eacute;ditable.
Inscription manuelle : les participants doivent &ecirc;tre ajout&eacute;s   &agrave; partir de la liste des participants en choisissant le participant parmi la liste des &laquo; Participants potentiels &raquo; (droit) et ajout&eacute;s   &agrave; l\'aide de la fl&egrave;che au &quot;Participant actuel&quot; (gauche). NB.  Dans les deux modes d\'inscription, l\'utilisateur qui cr&eacute;era l\'activit&eacute; est ajout&eacute; comme pr&eacute;sentateur de fa&ccedil;on automatique, mais reste &eacute;ditable, tout comme la liste des animateurs. Il n\'est pas possible d\'avoir plus d\'un pr&eacute;sentateur.';
$string['automaticenrol'] = 'Inscription automatique';
$string['manualenrol'] = 'Inscription manuelle';
$string['categoriesheader'] = 'Cat&eacute;gories';
$string['nocategories'] = 'Aucune cat&eacute;gorie';
$string['category'] = 'Choisissez une cat&eacute;gorie';
$string['via_categoriesdesc'] = 'Si cette case est coch&eacute;e, des cat&eacute;gories cr&eacute;&eacute;es dans Via pourront &ecirc;tre ajout&eacute; &agrave; l\'activit&eacute;.';
$string['choosecategories'] = 'Configurez les cat&eacute;gories';
$string['downloadplaybacks'] = 'T&eacute;l&eacute;charger les enregistrements';
$string['downloadplaybacksdesc'] = 'Si cette case est coch&eacute;e, les utilisateurs avec des roles d\'&eacute;dition seront autoris&eacute;s &agrave; t&eacute;l&eacute;charger des enregistrements  Via. Avant de cocher cette case, veuillez contacter SVIesolutions pour valider que votre serveur le permet.';
$string['presencestatus'] = 'Rapport de pr&eacute;sence sur les activit&eacute;s';
$string['presencestatusdesc'] = 'Si cette case est coch&eacute;e, il vous est alors possible de fixer un temps minimum de pr&eacute;sence (en minutes) afin que vos utilisateurs soient consid&eacute;r&eacute;s comme pr&eacute;sents dans votre activit&eacute;. Ainsi, si vous fixez  &agrave; 50 minutes le seuil de pr&eacute;sence pour votre activit&eacute;, et que votre utilisateur s\'y connecte pendent 48 minutes, il sera consid&eacute;r&eacute; comme absent par le syst &egrave;me.';
$string['cat_intro'] = 'Choisissez les cat&eacute;gories de Via que vous voulez rendre disponible dans Moodle.';
$string['no_default'] = 'Aucune cat&eacute;gorie par d&eacute;faut.';
$string['cats_modified'] = 'Les cat&eacute;gories ont &eacute;t&eacute; modifi&eacute;es avec succ&egrave;s';
$string['cat_name'] = 'Noms des cat&eacute;gories';
$string['cat_check'] = 'Ajouter';
$string['cat_default'] = 'Par d&eacute;faut';
$string['modulename'] = 'Via';
$string['modulenameplural'] = 'Via';
$string['name'] = 'Nom ';
$string['date'] = 'Date de l\'activit&eacute;';
$string['passdate'] = 'La date s&eacute;lectionn&eacute;e est d&eacute;pass&eacute;e.';
$string['apiconfig'] = 'Configuration de l\'API - &Eacute;tape 1';
$string['cieid'] = 'Cl&eacute; Via (CieID)';
$string['cieidsetting'] = 'Identifiant de l\'organisation &agrave; laquelle l\'utilisateur est associ&eacute; dans Via.';
$string['apiid'] = 'Cl&eacute; API (ApiID)';
$string['apiidsetting'] = 'Identifiant unique donn&eacute; &agrave; ceux qui communiquent avec l\'API. Cette donn&eacute;e est compar&eacute;e avec l\'IP du serveur appelant.';
$string['apiurl'] = 'URL de l\'API de Via';
$string['apiurlsetting'] = 'URL de base de l\'API pour Via';
$string['moodle_config'] = 'Configuration de l\'API - &Eacute;tape 2';
$string['moodle_adminid'] = 'Cl&eacute; Admin Moodle';
$string['moodleidsetting'] = 'ID Administrateur unique pour ce moodle';
$string['viaaudiotypes'] = 'S&eacute;lectionnez les modes audios que vous voulez conserver.';
$string['options'] = 'Options pour l\'activit&eacute;';
$string['participantmustconfirm'] = 'Confirmation de pr&eacute;sence';
$string['participantmustconfirmdesc'] = 'Si cette option est coch&eacute;e, l\'option est disponible lors de la cr&eacute;ation des nouvelles l\'activit&eacute;s. Le tableau de confirmation de pr&eacute;sence appara &icirc;tra dans le bas de la page de la liste des participants apr &egrave;s la fin de l\'activit&eacute;.';
$string['participantsynchronization'] = 'Synchroniser les informations des participants';
$string['participantsynchronizationdesc'] = 'Cette option permet de synchroniser les informations des utilisateurs, incluant leur avatar, lors de leur connexion  &agrave; Via. M &ecirc;me si cette option est coch&eacute;e, le code d\'utilisateur Via, le type d\'utilisateur Via et le mot de passe dans Via ne seront pas mis  &agrave; jour.';
$string['permanentactivities'] = 'Activit&eacute;s permanents';
$string['permanentactivitiesdesc'] = 'Cochez cette case si vous d&eacute;sirez que vos utilisateurs puissent cr&eacute;er des activit&eacute;s permanentes (qui n\'ont pas de date de d&eacute;but et de fin).';
$string['technicalassist_url'] = 'Sp&eacute;cifier une page d\'assistance technique';
$string['technicalassist_urldesc'] = 'Par d&eacute;faut, la page d\'assistance technique affichera les informations fournies dans Via. Vous pouvez sp&eacute;cifier une page personnalis&eacute;e d\'assistance en appelant directement l\'URL. Cela peut  &ecirc;tre une page cr&eacute;&eacute;e dans Moodle ou un autre site. ';
$string['activitydeletion'] = 'Limiter la suppression d\'activit&eacute;';
$string['activitydeletiondesc'] = 'Si cette case est coch&eacute;e, les activiti&eacute;s seront supprim&eacute;es dans Moodle, mais pas dans Via.';
$string['versionscompatible'] = 'Les versions du module et de VIA sont compatible.';
$string['versions_not_compatible'] = 'Les versions du module et de VIA ne sont pas compatible. Cette version du module requi&egrave;re un minimum de ';

$string['backup_options'] = 'Sauvegarde d\'activit&eacute; et les options de duplication';
$string['duplication'] = 'Inclure dans la duplication';
$string['duplicationdesc'] = 'Si cette case est coch&eacute;e, les tableaux blancs et sondages d\'une activit&eacute; seront inclus  &agrave; la nouvelle activit&eacute; cr&eacute;&eacute;e pendant le processus de duplication. Les utilisateurs et les documents sont toujours inclus dans ce processus.';
$string['backup'] = 'Inclure dans la sauvegarde de cours';
$string['backupdesc'] = 'Si cette case est coch&eacute;e, les tableaux blancs et sondages d\'une activit&eacute; seront inclus dans la sauvegarde du cours. Les documents sont toujours inclus dans ce processus tandis que l\'ajout des utilisateurs est facultatif.';

$string['emails_alert_address'] = 'Courriels pour l\'envoie d\'avertissements';
$string['emails_alert_addressdesc'] = 'Adresses courriels pour l\'envoie des avertissements de d&eacute;bordement. Si plusieurs, s&eacute;parer les adresses par des virgules.';
$string['testconnection'] = 'Tester la connexion &agrave; l\'API';
$string['testadminid'] = 'Tester la cl&eacute; moodle';
$string['adminid_success'] = 'La cl&eacute; moodle a &eacute;t&eacute; test&eacute;e avec succ&egrave;ss.';
$string['adminid_toolow'] = 'Les droits de l\'utilisateur ne permettront pas la cr&eacute;ation d\'activit&eacute;s, veuillez contacter l\'administrateur du site pour faire augmenter les droits';
$string['adminid_nosuccess'] = 'La cl&eacute; moodle n\'est pas valide.';
$string['adminnotrenrolled'] = 'En tant qu\'administrateur vous avez acc&egrave;s &agrave; l\'activit&eacute; malgr&eacute; ne pas &ecirc;tre inscrit.';

$string['reminderemailsubject'] = 'RAPPEL : {$a->title}';
$string['reminderemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title} reminderemail
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

L\'actitiv&eacute; &quot; {$a->title} &quot; qui aura lieu le {$a->datebegin} de {$a->hourbegin} &agrave; {$a->hourend}.

---------------------------------------------------------------------
Pr&eacute;paration &agrave; l\'activit&eacute;

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}

Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Acc&egrave;s Web

Pour acc&eacute;der &agrave; l\'activit&eacute;, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------

Attention : Chaque activit&eacute; peut &ecirc;tre enregistr&eacute;e. Merci de ne pas y acc&eacute;der si vous ne voulez pas &ecirc;tre enregistr&eacute;. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas &ecirc;tre partag&eacute;es.';
$string['reminderemailhtml'] = '<p>Bonjour {$a->username}, reminderemailhtml</p>
<p>Ceci est un rappel pour une activit&eacute; qui aura lieu sous peu :</p>
<p><b>Titre :</b> {$a->title}<br/>
<b>Date et heure :</b> {$a->activitydate}<br/>
<b>Dur&eacute;e :</b> {$a->duration} minutes</p>';

$string['inviteemailsubject'] = 'INVITATION : {$a->title}';

/* regular invites */
$string['inviteemail'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

L\'actitiv&eacute; &quot; {$a->title} &quot; qui aura lieu le {$a->datebegin} de {$a->hourbegin} &agrave; {$a->hourend}.

{$a->invitemsg}

---------------------------------------------------------------------
Pr&eacute;paration &agrave; l\'activit&eacute;

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}
Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Acc&egrave;s Web

Pour acc&eacute;der &agrave; l\'activit&eacute;, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------


Attention : Chaque activit&eacute; peut &ecirc;tretre enregistr&eacute;e. Merci de ne pas y acc&eacute;der si vous ne voulez pas &ecirc;tre enregistr&eacute;. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas &ecirc;tre partag&eacute;es.';

$string['inviteemailhtml'] = '<p>Bonjour {$a->username},</p>
<p>L\'activit&eacute; &laquo; {$a->title} &raquo; aura lieu le <b>{$a->datebegin}</b> de <b>{$a->hourbegin}</b> &agrave; <b>{$a->hourend}</b>.</p><p>{$a->invitemsg}</p>';

/* Invites modified for permanent activities. */
$string['inviteemailpermanent'] = '{$a->coursename} -> {$a->modulename} -> {$a->title}
---------------------------------------------------------------------
{$a->datesend}
---------------------------------------------------------------------

Bonjour {$a->username},

{$a->invitemsg}

---------------------------------------------------------------------
Pr&eacute;paration &agrave; l\'activit&eacute;

Cliquez le lien suivant pour l\'assistant de configuration : {$a->config}
Cliquez le lien suivant pour l\'assistance technique : {$a->assist}

---------------------------------------------------------------------
Acc&egrave;s Web

Pour acc&eacute;der &agrave; l\'activit&eacute;, cliquez sur ce lien : {$a->activitylink}

---------------------------------------------------------------------

Attention : Chaque activit&eacute; peut &ecirc;tretre enregistr&eacute;e. Merci de ne pas y acc&eacute;der si vous ne voulez pas &ecirc;tre enregistr&eacute;. Ce courriel contient vos informations personnelles de connexion. Ces informations ne doivent pas &ecirc;tre partag&eacute;es.';

$string['inviteemailhtmlpermanent'] = '<p>Bonjour {$a->username},</p>

<p>{$a->invitemsg}</p>';

$string['invitewebaccesshtml'] = 'Acc&egrave;s Web';
$string['invitepreparationhtml'] = 'Pr&eacute;paration &agrave; l\'activit&eacute;';
$string['inviteclicktoaccesshtml'] = 'Pour acc&eacute;der &agrave; l\'activit&eacute;, cliquez sur ce lien :';
$string['invitewarninghtml'] = 'Attention : Chaque activit&eacute; peut &ecirc;tre enregistr&eacute;e. Merci de ne pas y acc&eacute;der si vous ne voulez pas &ecirc;tre enregistr&eacute;. Ce courriel contient vos informations personnelles de connexion. Ces information ne doivent pas &ecirc;tre partag&eacute;es.';
$string['recordmodebehavior'] = 'Enregistrement';
$string['recordmodebehavior_help'] = 'En plus du mode, vous pouvez &eacute;galement d&eacute;cider de d&eacute;marrer automatiquement l\'enregistrement   &agrave; l\'acc&egrave;s en utilisant l\'option &laquo; Automatique &raquo;. Choisissez l\'option &laquo; Manuel &raquo; si vous ne d&eacute;sirez pas que l\'enregistrement d&eacute;marre automatiquement   &agrave; l\'acc&egrave;s. Vous devrez alors d&eacute;marrer l\'enregistrement vous-m&ecirc;me en acc&eacute;dant   &agrave; l\'interface synchrone.';
$string['automatic'] = 'Automatique';
$string['manual'] = 'Manuel';
$string['waitingroomaccessmode'] = 'Salle d\'attente';
$string['waitingroomaccessmode_help'] = 'L\'option &laquo; En attente d\'autorisation &raquo; permet au pr&eacute;sentateur d\'autoriser individuellement l\'acc&egrave;s des participants tandis que l\'option &laquo; En l\'absence du pr&eacute;sentateur &raquo; vous assure qu\'aucun utilisateur ne pourra acc&eacute;der   &agrave; l\'activit&eacute; tant que le pr&eacute;sentateur n\'est pas connect&eacute;. Cette derni&egrave;re option est particuli&egrave;rement utile lors d\'activit&eacute;s permanentes';
$string['donousewaitingroom'] = 'Ne pas utiliser (d&eacute;sactiver;)';
$string['awaitingauthorization'] = 'En attente d\'autorisation (manuelle)';
$string['inpresentatorabsence'] = 'En l\'absence du pr&eacute;sentateur (automatique)';
$string['notactivatedfeminin'] = 'D&eacute;sactiv&eacute;e';
$string['resetdeletemodules'] = 'Supprimer toutes les activit&eacute;s';
$string['resetparticipants'] = 'Retirer tous les participants et animateurs (fonctionne seulement pour les activit&eacute;s avec inscription manuelle)';
$string['resetdisablereviews'] = 'D&eacute;sactiver le revisionnement des activit&eacute;s';
$string['by'] = 'par';
$string['list_activities'] = 'Liste de toutes les activit&eacute;s Via dans ce cours';
$string['no_categories'] = 'Il n\'y a aucune cat&eacute;gories de disponible, celles-ci doivent &ecirc;tre cr&eacute;&eacute;s dans le portail Via par un administrateur.';
$string['via:addinstance'] = 'Ajouter une activit&eacute; Via';
$string['activity_deleted'] = 'L\'activit&eacute; Via a &eacute;t&eacute; supprim&eacute;e directement dans l\'environnement Via par un utilisateur. Il est donc impossible d\'y acc&eacute;der. Nous vous recommandons de supprimer cette activit&eacute; dans Moodle et d\'en cr&eacute;er une nouvelle. ';
$string['noparticipantscheckbox'] = 'Ajouter les &eacute;tudiants comme animateurs.';
$string['noparticipants_help'] = 'Cette option est disponible seulement en mode d\'inscription automatique et fait en sorte que les utilisateurs ayant le statut d\'&eacute;tudiant sont tous inscrits avec les droits d\'animateurs dans via.';
$string['userispresentor'] = 'Cet utilisateur est le pr&eacute;sentateur. Veuillez d&eacute;signer un nouveau pr&eacute;sentateur afin de modifier le r&ocirc;le de cet utilisateur.';
$string['choosepresentor'] = 'Un seul pr&eacute;sentateur peut &ecirc;tre associ&eacute; &agrave; l\'activit&eacute;. Pour choisir un nouveau pr&eacute;sentateur, simplement ajouter un utilisateur comme pr&eacute;sentateur. Il sera automatiquement substitu&eacute;.';
$string['mask'] = 'Cach&eacute;';
$string['show'] = 'Affich&eacute;';
$string['availabledate'] = 'Disponible d&egrave;s le';
$string['title_exists'] = 'Le titre existe d&eacute;j&agrave;, veuillez essayer &agrave; nouveau.';
$string['copied'] = ' - Copie';
$string['connectsuccess'] = 'Connexion &agrave; l\'API r&eacute;ussie avec succ&egrave;s.';
$string['conntest'] = 'Test de connexion';
$string['oldapiversion'] = 'Vous utilisez une version anterieur &agrave; {$a} de l\'API';
$string['activitywaserased'] = 'Impossible de trouver cette activit&eacute; sur le serveur SVI. Elle semble avoir &eacute;t&eacute; supprim&eacute;e.';
$string['groupusers'] = 'Les utilisateurs du groupement associ&eacute; : {$a} ne peuvent pas &ecirc;tre dissoci&eacute;s de l\'activit&eacute;, mais vous pouvez en ajouter.';
$string['presencetable'] = 'Statut de pr&eacute;sence : ';
$string['presenceheader'] = 'Pr&eacute;sence en direct (h:m:s)';
$string['presenceheaderreport'] = 'Pr&eacute;sence en direct';
$string['playbackheader'] = 'Diff&eacute;r&eacute; (h:m:s)';
$string['present'] = 'Pr&eacute;sent';
$string['absent'] = 'Absent';
$string['presencewarning'] = 'Important : Le Statut de pr&eacute;sence en direct est d&eacute;termin&eacute; en fonction du temps minimum requis pour &ecirc;tre consid&eacute;r&eacute; pr&eacute;sent pour cette activit&eacute;. Ce statut influence la barre de progression du participant dans le d&eacute;roulement de son parcours. Il vous est possible d\'ajuster ce statut en modifiant la valeur &laquo; Temps minimum requis de pr&eacute;sence &raquo; dans les param&egrave;tres de l\'activit&eacute;.';
$string['basedon'] = 'Le statut de pr&eacute;sence est bas&eacute; sur {$a} minutes.';
$string['report'] = 'Rapport de pr&eacute;sence';
$string['createdby'] = 'Rapport g&eacute;n&eacute;r&eacute; par : ';
$string['creationdate'] = 'Date de cr&eacute;ation du rapport :';
$string['return'] = 'Retour';
$string['cancel'] = 'Annuler';

/* Permissions */
$string['via:manage'] = 'G&eacute;rer les activit&eacute;s Via';
$string['via:viewpresence'] = 'Voir les rapports de pr&eacute;sence pour les activit&eacute;s Via';
$string['via:view'] = 'Voir les activit&eacute;s Via';

/* Errors */
$string['error_user'] = 'Une erreur est survenue, l\'utilisateur {$a} n\'a pas pu &ecirc;tre ajout&eacute; &agrave; l\'activit&eacute;.';
$string['STATUS_INVALID'] = 'La connexion n&acute;est pas possible.';
$string['error:deletefailed'] = 'La suppression des activit&eacute;s a &eacute;chou&eacute;e.';
$string['error:resetparticipants'] = 'Le retrait des participants a &eacute;chou&eacute;.';
$string['error:disablereviews'] = 'La d&eacute;sactivation du mode revoir a &eacute;chou&eacute;e.';
$string['error:URL_ERROR'] = 'URL_ERROR - L\'url de l\'API n\'existe pas. Merci de v&eacute;rifier les informations de configuration.';
$string['error:allseatstaken'] = 'D&eacute;sol&eacute;, tous les si&egrave;ges disponibles sur le serveur SVI sont pris. Vous ne pouvez donc pas acc&eacute;der &agrave; cette activit&eacute; pour le moment. Un avis vient d\'&ecirc;tre envoy&eacute; aux responsables afin de les aviser du d&eacute;bordement. Vous pouvez &eacute;galement envoy&eacute; un courriel &agrave; <a href=\'mailto:$a->email?subject=Avis de debordement sur Via\'>{$a->email}</a> pour les aviser.<br><br> Veuillez r&eacute;essayer de vous connecter plus tard.';
$string['error:CIEID_NOT_FOUND'] = 'La CieID n\'existe pas. Merci de v&eacute;rifier les informations de configuration.';
$string['error:APIID_NOT_FOUND'] = 'L\'ApiID n\'existe pas. Merci de v&eacute;rifier les informations de configuration.';
$string['error:ACTIVITY_ACCESS_FAILED'] = 'ACTIVITY_ACCESS_FAILED - Lorsque l\'utilisateur n\'est pas associ&eacute; ou n\'a pas le droit d\'acc&egrave;s &agrave; cette rencontre ou que la rencontre n\'est pas encore accessible.';
$string['error:ACTIVITY_DOES_NOT_EXIST'] = 'ACTIVITY_DOES_NOT_EXIST - Doit repr&eacute;senter une activit&eacute; valide.';
$string['error:ACTIVITYID_EMPTY'] = 'ACTIVITYID_EMPTY - La valeur ActivityID est vide.';
$string['error:ACTIVITYID_INVALID'] = 'ACTIVITYID_INVALID - La valeur pass&eacute;e dans le noeud ActivityID n\'est pas valide.';
$string['error:APIID_NOT_FOUND'] = 'APIID_NOT_FOUND - L\'ApiID n\'existe pas. Merci de v&eacute;rifier les informations de configuration.';
$string['error:APPLY_PERIODICITY_INVALID'] = 'APPLY_PERIODICITY_INVALID - La valeur pass&eacute;e doit &ecirc;tre 0 ou 1.';
$string['error:AUTH_FAILED_BAD_APIID'] = 'AUTH_FAILED_BAD_APIID - La valeur APIID n\'est pas authoris&eacute;e.';
$string['error:AUTH_FAILED_BAD_CIEID'] = 'AUTH_FAILED_BAD_CIEID - La valeur CieID n\'est pas authoris&eacute;e.';
$string['error:CANNOT_CHANGE_STATE'] = 'CANNOT_CHANGE_STATE - L\'activit&eacute; ne peut changer d\'&eacute;tat.';
$string['error:CIEID_NOT_FOUND'] = 'CIEID_NOT_FOUND - La CieID n\'existe pas. Merci de v&eacute;rifier les informations de configuration.';
$string['error:COMPANYNAME_TOO_LONG'] = 'COMPANYNAME_TOO_LONG - La valeur CompanyName d&eacute;passe le maximum de 50 caract&egrave;res.';
$string['error:EMAIL_TOO_LONG'] = 'EMAIL_TOO_LONG - La valeur Email d&eacute;passe le  maximum de 100 caract&egrave;res.';
$string['error:ERROR_AUTH_BAD_CIEID'] = 'ERROR_AUTH_BAD_CIEID - La valeur IP de l\'appelant n\'est pas valide.';
$string['error:ERROR_FAILED_EDIT_USER'] = 'ERROR_FAILED_EDIT_USER - Erreur dans l\'&eacute;dition. L\'usager n\'a pas &eacute;t&eacute; modifi&eacute;.';
$string['error:ERROR_LOGIN_NO_SPACE_ALLOWED'] = 'ERROR_LOGIN_NO_SPACE_ALLOWED - Le login contient des espaces.';
$string['error:FIRSTNAME_TOO_LONG'] = 'FIRSTNAME_TOO_LONG - La valeur Firsname d&eacute;passe le maximum de 50 caract&egrave;res.';
$string['error:FONCTIONTILE_TOO_LONG'] = 'FONCTIONTILE_TOO_LONG - La valeur Fonction d&eacute;passe le maximum de 50 caract&egrave;res.';
$string['error:INVALID_ACTIVITYID'] = 'INVALID_ACTIVITYID - Lorsque la valeur ID de l\'activit&eacute; synchrone n\'est pas valide.';
$string['error:INVALID_ACTIVITYSTATE'] = 'INVALID_ACTIVITYSTATE - La valeur pass&eacute;e dans le noeud ActivityState n\'est pas valide.';
$string['error:INVALID_ACTIVITYTYPE'] = 'INVALID_ACTIVITYTYPE - La valeur pass&eacute;e dans le noeud ActivityType n\'est pas valide.';
$string['error:INVALID_AUDIOTYPE'] = 'INVALID_AUDIOTYPE - La valeur pass&eacute;e dans le noeud AudioType n\'est pas valide.';
$string['error:INVALID_CIEID'] = 'INVALID_CIEID - La valeur CIEID doit &ecirc;tre une valeur num&eacute;rique.';
$string['error:INVALID_CONFIRMATION_STATUS'] = 'INVALID_CONFIRMATION_STATUS - La valeur pass&eacute;e dans le noeud ConfirmationStatus n\'est pas valide.';
$string['error:INVALID_DATE'] = 'INVALID_DATE - Date au format AAAA-MM-JJ HH:MM:SS.';
$string['error:INVALID_DURATION'] = 'INVALID_DURATION - La valeur DURATION doit &ecirc;tre une valeur num&eacute;rique.';
$string['error:INVALID_FRIDAY_VALUE'] = 'INVALID_FRIDAY_VALUE - La valeur de la propri&eacute;t&eacute; Friday est invalide.';
$string['error:INVALID_GENDER'] = 'INVALID_GENDER - La valeur pass&eacute;e dans le noeud Genre n\'est pas valide.';
$string['error:INVALID_ISNUMBEREDTITLE'] = 'INVALID_ISNUMBEREDTITLE - La valeur pass&eacute;e dans le noeud IsNumberedTitle n\'est pas valide.';
$string['error:INVALID_ISPUBLIC'] = 'INVALID_ISPUBLIC - La valeur ISPUBLIC doit &ecirc;tre 0 ou 1.';
$string['error:INVALID_ISRECORDED'] = 'INVALID_ISRECORDED - La valeur pass&eacute;e dans le noeud IsRecorded n\'est pas valide..';
$string['error:INVALID_ISREPLAYALLOWED'] = 'INVALID_ISREPLAYALLOWED - La valeur pass&eacute;e dans le noeud IsReplayAllowed n\'est pas valide.';
$string['error:INVALID_LANGUAGE'] = 'INVALID_LANGUAGE - La valeur pass&eacute;e dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_MAIL_FORMAT'] = 'INVALID_MAIL_FORMAT - Le format du courriel n\'est pas valide.';
$string['error:INVALID_MONDAY_VALUE'] = 'INVALID_MONDAY_VALUE - La valeur de la propri&eacute;t&eacute; Monday est invalide.';
$string['error:INVALID_MONTHLYDAY'] = 'INVALID_MONTHLYDAY - La valeur de la journ&eacute;e mensuel n\'est pas valide.';
$string['error:INVALID_NEEDCONFIRMATION'] = 'INVALID_NEEDCONFIRMATION - La valeur pass&eacute;e dans le noeud NeedConfirmation n\'est pas valide.';
$string['error:INVALID_OBJECT_FORMAT'] = 'INVALID_OBJECT_FORMAT - Le INNERXML du soap:body est invalide.';
$string['error:INVALID_PARTICIPANT_TYPE'] = 'INVALID_PARTICIPANT_TYPE - La valeur pass&eacute;e dans le noeud ParticipantType n\'est pas valide.';
$string['error:INVALID_PERIODICITY_ENDDATE'] = 'INVALID_PERIODICITY_ENDDATE - Date au format AAAA-MM-JJ.';
$string['error:INVALID_PERIODICITY_STARTDATE'] = 'INVALID_PERIODICITY_STARTDATE - Date au format AAAA-MM-JJ HH:MM:SS.';
$string['error:INVALID_PHONERIGHT'] = 'INVALID_PHONERIGHT - Le pont t&eacute;l&eacute;phonique n\'est pas actif pour cette compagnie.';
$string['error:INVALID_PLAYBACK_ID'] = 'INVALID_PLAYBACK_ID - La valeur ID du playback n\'est pas valide.';
$string['error:PLAYBACK_NOT_PUBLIC'] = 'PLAYBACK_NOT_PUBLIC - Ce playback n\'est pas disponible a tous.';
$string['error:INVALID_PROFILID'] = 'INVALID_PROFILID - Le profil n\'est pas valide ou n\'existe pas pour le client.';
$string['error:INVALID_RECNOTIFICATION'] = 'INVALID_RECNOTIFICATION - La valeur pass&eacute;e dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_RECORDMODEBEHAVIOR'] = 'INVALID_RECORDMODEBEHAVIOR - La valeur pass&eacute;e dans le noeud RecordModeBehaviour n\'est pas valide.';
$string['error:INVALID_REDIRECT_TYPE'] = 'INVALID_REDIRECT_TYPE - La valeur pass&eacute;e au noeud RedirectType n\'est pas valide.';
$string['error:INVALID_REMINDERTIME'] = 'INVALID_REMINDERTIME - La valeur pass&eacute;e dans le noeud ReminderTime n\'est pas valide.';
$string['error:INVALID_ROOMTYPE'] = 'INVALID_ROOMTYPE - La valeur pass&eacute;e dans le noeud RoomType n\'est pas valide.';
$string['error:INVALID_SATURDAY_VALUE'] = 'INVALID_SATURDAY_VALUE - La valeur de la propri&eacute;t&eacute; Saturday est invalide.';
$string['error:INVALID_SOAP_FORMAT'] = 'INVALID_SOAP_FORMAT - La requ&ecirc;te SOAP n\'a pas &eacute;t&eacute; instanci&eacute;e correctement.';
$string['error:INVALID_STATUS'] = 'INVALID_STATUS - La valeur pass&eacute;e dans le noeud Status n\'est pas valide.';
$string['error:INVALID_SUNDAY_VALUE'] = 'INVALID_SUNDAY_VALUE - La valeur de la propri&eacute;t&eacute; Sunday est invalide.';
$string['error:INVALID_THURSDAY_VALUE'] = 'INVALID_THURSDAY_VALUE - La valeur de la propri&eacute;t&eacute; Thursday est invalide.';
$string['error:INVALID_TIMEZONE'] = 'INVALID_TIMEZONE - La valeur pass&eacute;e dans le noeud TIMEZONE n\'est pas valide.';
$string['error:INVALID_TITLE_TOO_LONG'] = 'INVALID_TITLE_TOO_LONG - Le titre d&eacute;passe le maximum de 100 caract&egrave;res.';
$string['error:INVALID_TUESDAY_VALUE'] = 'INVALID_TUESDAY_VALUE - La valeur de la propri&eacute;t&eacute; Tuesday est invalide.';
$string['error:INVALID_USER_RIGHT'] = 'INVALID_USER_RIGHT - L\'utilisateur n\'a pas le droit d\'&eacute;dition ou de cr&eacute;ation sur les activit&eacute;s.';
$string['error:INVALID_USERID'] = 'INVALID_USERID - La valeur ID de l\'utilisateur n\'est pas valide.';
$string['error:INVALID_USERTYPE'] = 'INVALID_USERTYPE - La valeur pass&eacute;e dans le noeud LANGAGE n\'est pas valide.';
$string['error:INVALID_WAITINGROOMACCESSMODE'] = 'INVALID_WAITINGROOMACCESSMODE - La valeur pass&eacute;e dans le noeud WaitingRoomAccesMode n\'est pas valide.';
$string['error:INVALID_WEDNESDAY_VALUE'] = 'INVALID_WEDNESDAY_VALUE - La valeur de la propri&eacute;t&eacute; Wednesday est invalide.';
$string['error:LASTNAME_TOO_LONG'] = 'LASTNAME_TOO_LONG - La valeur Lastname d&eacute;passe le maximum de 50 caract&egrave;res.';
$string['error:LOGIN_EMPTY'] = 'LOGIN_EMPTY - La valeur Login est vide.';
$string['error:LOGIN_TOO_LONG'] = 'LOGIN_TOO_LONG - La valeur Login d&eacute;passe le maximum de 15 caract&egrave;res.';
$string['error:LOGIN_USED'] = 'LOGIN_USED - La valeur Login est d&eacute;j&agrave; utilis&eacute;e.';
$string['error:PASSWORD_EMPTY'] = 'PASSWORD_EMPTY - La valeur Password est vide.';
$string['error:PASSWORD_TOO_LONG'] = 'PASSWORD_TOO_LONG - La valeur Password d&eacute;passe le maximum de 15 caract&egrave;res.';
$string['error:PERIODICITY_NODE_MISSING'] = 'PERIODICITY_NODE_MISSING - La node P&eacute;riodicit&eacute; n\'a pas &eacute;t&eacute; pass&eacute;.';
$string['error:PHONEBUS_TOO_LONG'] = 'PHONEBUS_TOO_LONG - La valeur PHONEBUS d&eacute;passe le maximum de 20 caract&egrave;res.';
$string['error:PHONECEL_TOO_LONG'] = 'PHONECEL_TOO_LONG - La valeur PHONECEL d&eacute;passe le maximum de 20 caract&egrave;res.';
$string['error:PHONEHOME_TOO_LONG'] = 'PHONEHOME_TOO_LONG - La valeur PHONEHOME d&eacute;passe le maximum de 20 caract&egrave;res.';
$string['error:TITLE_IS_REQUIRED'] = 'TITLE_IS_REQUIRED - Le titre est requis.';
$string['error:TITLE_TOO_LONG'] = 'TITLE_TOO_LONG - La valeur Title d&eacute;passe le maximum de 100 caract&egrave;res.';
$string['error:UNABLE_TO_CREATEDATE'] = 'UNABLE_TO_CREATEDATE - Erreur dans la cr&eacute;ation des dates de la p&eacute;riodicit&eacute;.';
$string['error:USER_DOES_NOT_EXIST'] = 'USER_DOES_NOT_EXIST - L\'usager n\'est pas valide..';
$string['error:USERID_EMPTY'] = 'USERID_EMPTY - La valeur UserID est vide.';
$string['error:STATUS_INVALID'] = 'La connexion &agrave; la salle de web conf&eacute;rence n&acute;est pas possible puisque votre utilisateur Via est supprim&eacute; ou inactif. <br/>
Veuillez communiquer avec l&acute;administrateur Via de votre institution afin de faire r&eacute;activer votre utilisateur Via.';
$string['error:RECORD_NOT_DOWNLOADABLE'] = 'L\'enregistrement n\'est pas disponible.';
$string['error:INVALID_RECORD_TYPE'] = 'Le type d\'enregistrement n\'est pas valide.';
$string['error:USER_DOWNLOAD_NOT_ALLOWED'] = 'L\'utilisateur n\'a pas le droit de t&eacute;l&eacute;charger l\'enregistrement.';
$string['error:Problem reading result xm'] = 'Problem reading result xml';
